// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/vr_service.mojom
//

package org.chromium.mojom.content;

public final class VrEyeParameters extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public VrFieldOfView minimumFieldOfView;
    public VrFieldOfView maximumFieldOfView;
    public VrFieldOfView recommendedFieldOfView;
    public VrVector3 eyeTranslation;
    public VrRect renderRect;

    private VrEyeParameters(int version) {
        super(STRUCT_SIZE, version);
    }

    public VrEyeParameters() {
        this(0);
    }

    public static VrEyeParameters deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static VrEyeParameters decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        VrEyeParameters result = new VrEyeParameters(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
            result.minimumFieldOfView = VrFieldOfView.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
            result.maximumFieldOfView = VrFieldOfView.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
            result.recommendedFieldOfView = VrFieldOfView.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
            result.eyeTranslation = VrVector3.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
            result.renderRect = VrRect.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(minimumFieldOfView, 8, false);
        encoder0.encode(maximumFieldOfView, 16, false);
        encoder0.encode(recommendedFieldOfView, 24, false);
        encoder0.encode(eyeTranslation, 32, false);
        encoder0.encode(renderRect, 40, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        VrEyeParameters other = (VrEyeParameters) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.minimumFieldOfView, other.minimumFieldOfView))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.maximumFieldOfView, other.maximumFieldOfView))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.recommendedFieldOfView, other.recommendedFieldOfView))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.eyeTranslation, other.eyeTranslation))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.renderRect, other.renderRect))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(minimumFieldOfView);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(maximumFieldOfView);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(recommendedFieldOfView);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(eyeTranslation);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(renderRect);
        return result;
    }
}

